/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.platforms.core.client.models.data.IBlockModelData;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    private static final SimpleMaxSizedCache<class_2487, class_1087> STACK_MODEL_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getStackModelCacheSize())::get);

    @Override
    public boolean method_4708() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    @Override
    public class_1087 handleBlockState(class_2680 state, Random random, IBlockModelData modelData) {
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) && !modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) || IRenderTypeManager.getInstance().getCurrentRenderType().isEmpty()) {
            return modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
        }
        return modelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY).getOrDefault(IRenderTypeManager.getInstance().getCurrentRenderType().get(), NullBakedModel.instance);
    }

    @Override
    public class_1087 resolve(class_1087 originalModel, class_1799 stack, class_1937 world, class_1309 entity) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        class_2487 cacheKey = stack.method_7953(new class_2487());
        return STACK_MODEL_CACHE.get(cacheKey, () -> {
            class_1087[] typedModels;
            IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
                typedModels = (class_1087[])Arrays.stream(VoxelType.values()).map(ChiselRenderType::getRenderTypes).filter(types -> !types.isEmpty()).map(types -> {
                    class_1087[] models = (class_1087[])types.stream().map(type -> ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, (ChiselRenderType)((Object)((Object)((Object)type))))).filter(Optional::isPresent).map(Optional::get).filter(model -> !model.isEmpty()).toArray(class_1087[]::new);
                    if (models.length == 0) {
                        return ChiseledBlockBakedModel.EMPTY;
                    }
                    return new CombinedModel(models);
                }).toArray(class_1087[]::new);
            }
            if (typedModels.length == 0) {
                return ChiseledBlockBakedModel.EMPTY;
            }
            ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
            try {
                CombinedModel combinedModel = new CombinedModel(typedModels);
                return combinedModel;
            }
            finally {
                if (ignored1 != null) {
                    ignored1.close();
                }
            }
        });
    }
}

